<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class VI_WOO_ALIDROPSHIP_Admin_System
 */
class VI_WOO_ALIDROPSHIP_Admin_Recommend {
	protected $dismiss;

	public function __construct() {
		$this->dismiss = 'wad_install_recommended_plugins_dismiss';
		add_action( 'admin_menu', array( $this, 'menu_page' ), 30 );
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );
		add_action( 'admin_init', array( $this, 'fix_dismiss_notice' ) );
	}

	public function fix_dismiss_notice() {
		$dismiss = get_option( $this->dismiss );
		if ( $dismiss ) {
			if ( $dismiss > 1600852690 ) {//2020-09-23 09:18:10 version 1.0.3.3 update time
				update_option( "{$this->dismiss}__email-template-customizer-for-woo", $dismiss );
			}
			update_option( "{$this->dismiss}__product-variations-swatches-for-woocommerce", $dismiss );
			delete_option( $this->dismiss );
		}
	}

	public static function admin_notices_html( $message, $button, $plugin_slug ) {
		?>
        <div class="villatheme-dashboard updated" style="border-left: 4px solid #ffba00">
            <div class="villatheme-content">
                <form action="" method="get">
                    <p><?php _e( $message ) ?></p>
                    <p><?php echo wp_kses_post( $button ) ?></p>
                    <a href="<?php echo esc_url( add_query_arg( array(
						'wad_dismiss_nonce' => wp_create_nonce( 'wad_dismiss_nonce' ),
						'plugin'            => $plugin_slug,
					) ) ) ?>" target="_self"
                       class="button notice-dismiss vi-button-dismiss"><?php esc_html_e( 'Dismiss', 'woo-alidropship' ) ?></a>
                </form>
            </div>
        </div>
		<?php
	}

	public function admin_notices() {
		global $pagenow;
		$action              = isset( $_REQUEST['action'] ) ? wp_unslash( sanitize_text_field( $_REQUEST['action'] ) ) : '';
		$_plugin             = isset( $_REQUEST['plugin'] ) ? wp_unslash( sanitize_text_field( $_REQUEST['plugin'] ) ) : '';
		$recommended_plugins = array(
			array(
				'slug'                => 'bulky-bulk-edit-products-for-woo',
				'pro'                 => '',
				'name'                => 'Bulky – Bulk Edit Products for WooCommerce',
				'message_not_install' => __( 'Quickly and easily edit your products in bulk with <strong>Bulky – Bulk Edit Products for WooCommerce</strong>', 'woo-alidropship' ),
				'message_not_active'  => __( '<strong>Bulky – Bulk Edit Products for WooCommerce</strong> is currently deactivated. Activate it to quickly edit your products in bulk', 'woo-alidropship' ),
			),
			array(
				'slug'                => 'email-template-customizer-for-woo',
				'pro'                 => 'woocommerce-email-template-customizer',
				'name'                => 'Email Template Customizer for WooCommerce',
				'message_not_install' => __( 'Try our brand new <strong>Email Template Customizer for WooCommerce</strong> plugin to easily customize your WooCommerce emails and make them more beautiful and professional.', 'woo-alidropship' ),
				'message_not_active'  => __( '<strong>Email Template Customizer for WooCommerce</strong> is currently deactivated. Activate it to customize WooCommerce emails with ease and make your customers more satisfied when receiving your emails.', 'woo-alidropship' ),
			),
			array(
				'slug'                => 'product-variations-swatches-for-woocommerce',
				'pro'                 => 'woocommerce-product-variations-swatches',
				'name'                => 'Product Variations Swatches for WooCommerce',
				'message_not_install' => __( 'Need a variations swatches plugin that works perfectly with ALD - Dropshipping and Fulfillment for AliExpress and WooCommerce? <strong>Product Variations Swatches for WooCommerce</strong> is what you need.', 'woo-alidropship' ),
				'message_not_active'  => __( '<strong>Product Variations Swatches for WooCommerce</strong> is currently deactivated, this prevents variable products from displaying beautifully.', 'woo-alidropship' ),
			),
		);
		$plugins             = get_plugins();
		foreach ( $recommended_plugins as $recommended_plugin ) {
			$plugin_slug = $recommended_plugin['slug'];
			if ( ! get_option( "{$this->dismiss}__{$plugin_slug}" ) ) {
				if ( ! empty( $recommended_plugin['pro'] ) && is_plugin_active( "{$recommended_plugin['pro']}/{$recommended_plugin['pro']}.php" ) ) {
					continue;
				}
				$plugin = "{$plugin_slug}/{$plugin_slug}.php";
				if ( ! isset( $plugins[ $plugin ] ) ) {
					if ( ! ( $pagenow === 'update.php' && $action === 'install-plugin' && $_plugin === $plugin_slug ) ) {
						$button = '<a href="' . esc_url( wp_nonce_url( self_admin_url( "update.php?action=install-plugin&plugin={$plugin_slug}" ), "install-plugin_{$plugin_slug}" ) ) . '" target="_self" class="button button-primary">' . esc_html__( 'Install now', 'woo-alidropship' ) . '</a>';
						self::admin_notices_html( $recommended_plugin['message_not_install'], $button, $plugin_slug );
					}
				} elseif ( ! is_plugin_active( $plugin ) ) {
					$button = '<a href="' . esc_url( wp_nonce_url( add_query_arg( array(
							'action' => 'activate',
							'plugin' => $plugin
						), admin_url( 'plugins.php' ) ), "activate-plugin_{$plugin}" ) ) . '" target="_self" class="button button-primary">' . esc_html__( 'Activate now', 'woo-alidropship' ) . '</a>';
					self::admin_notices_html( $recommended_plugin['message_not_active'], $button, $plugin_slug );
				}
			}
		}
	}

	public function admin_enqueue_scripts() {
		global $pagenow;
		$page = isset( $_REQUEST['page'] ) ? wp_unslash( sanitize_text_field( $_REQUEST['page'] ) ) : '';
		if ( $pagenow === 'admin.php' && $page === 'woo-ali-recommend' ) {
			wp_dequeue_style('eopa-admin-css');
			wp_enqueue_style( 'vi-woo-alidropship-form', VI_WOO_ALIDROPSHIP_CSS . 'form.min.css' );
			wp_enqueue_style( 'vi-woo-alidropship-table', VI_WOO_ALIDROPSHIP_CSS . 'table.min.css' );
			wp_enqueue_style( 'vi-woo-alidropship-icon', VI_WOO_ALIDROPSHIP_CSS . 'icon.min.css' );
			wp_enqueue_style( 'vi-woo-alidropship-segment', VI_WOO_ALIDROPSHIP_CSS . 'segment.min.css' );
			wp_enqueue_style( 'vi-woo-alidropship-button', VI_WOO_ALIDROPSHIP_CSS . 'button.min.css' );
		} else {
			$wad_dismiss_nonce = isset( $_REQUEST['wad_dismiss_nonce'] ) ? wp_unslash( sanitize_text_field( $_REQUEST['wad_dismiss_nonce'] ) ) : '';
			$dismiss_plugin    = isset( $_REQUEST['plugin'] ) ? wp_unslash( sanitize_text_field( $_REQUEST['plugin'] ) ) : '';
			if ( wp_verify_nonce( $wad_dismiss_nonce, 'wad_dismiss_nonce' ) ) {
				$option = $dismiss_plugin ? "{$this->dismiss}__{$dismiss_plugin}" : $this->dismiss;
				if ( ! get_option( $option ) ) {
					update_option( $option, time() );
				}
			}
			if ( ! get_option( $this->dismiss ) ) {
				add_action( 'admin_notices', array( $this, 'admin_notices' ) );
			}
		}
	}

	public function page_callback() {
		$plugins = Vi_Wad_Setup_Wizard::recommended_plugins();
		?>
        <style>
            .fist-col {
                min-width: 300px;
            }

            .vi-wad-plugin-name {
                font-weight: 600;
            }
        </style>
        <div class="">
            <h2><?php esc_html_e( 'Recommended plugins', 'woo-alidropship' ) ?></h2>
            <table cellspacing="0" id="status" class="vi-ui celled table">
                <thead>
                <tr>
                    <th></th>
                    <th><?php esc_html_e( 'Plugins', 'woo-alidropship' ); ?></th>
                    <th><?php esc_html_e( 'Description', 'woo-alidropship' ); ?></th>
                </tr>
                </thead>
                <tbody>
				<?php
				$installed_plugins = get_plugins();
				foreach ( $plugins as $plugin ) {
					$plugin_id = "{$plugin['slug']}/{$plugin['slug']}.php";
					?>
                    <tr>
                        <td><img src="<?php echo $plugin['img'] ?>" width="60" height="60"></td>
                        <td class="fist-col">
                            <div class="vi-wad-plugin-name">
								<?php echo $plugin['name'] ?>
                            </div>
                            <div>
								<?php
								if ( ! isset( $installed_plugins[ $plugin_id ] ) ) {
									?>
                                    <a href="<?php echo esc_url( wp_nonce_url( self_admin_url( "update.php?action=install-plugin&plugin={$plugin['slug']}" ), "install-plugin_{$plugin['slug']}" ) ) ?>"
                                       target="_blank"><?php esc_html_e( 'Install', 'woo-alidropship' ); ?></a>
									<?php
								} elseif ( ! is_plugin_active( $plugin_id ) ) {
									?>
                                    <a href="<?php echo esc_url( wp_nonce_url( add_query_arg( array(
										'action' => 'activate',
										'plugin' => $plugin_id
									), admin_url( 'plugins.php' ) ), "activate-plugin_{$plugin_id}" ) ) ?>"
                                       target="_blank"><?php esc_html_e( 'Activate', 'woo-alidropship' ); ?></a>
									<?php
								} else {
									esc_html_e( 'This plugin is currently in used', 'woo-alidropship' );
								}
								?>
                            </div>
                        </td>
                        <td><?php echo $plugin['desc'] ?></td>
                    </tr>
					<?php
				}
				?>
                </tbody>
            </table>
        </div>
		<?php
	}

	/**
	 * Register a custom menu page.
	 */
	public function menu_page() {
		add_submenu_page(
			'woo-alidropship',
			esc_html__( 'Recommended plugins for ALD - Dropshipping and Fulfillment for AliExpress and WooCommerce', 'woo-alidropship' ),
			esc_html__( 'Recommended plugins', 'woo-alidropship' ),
			'manage_options',
			'woo-ali-recommend',
			array( $this, 'page_callback' )
		);
	}
}
